

window.onload = function () {
    'use strict';

    var Cropper = window.Cropper;
    var URL = window.URL || window.webkitURL;
    var container = document.querySelector('.img-container');
    var image = container.getElementsByTagName('img').item(0);
    var download = document.getElementById('download');
    var actions0 = document.getElementById('actions0');
    var actions = document.getElementById('actions');
    var dataX = document.getElementById('dataX');
    var dataY = document.getElementById('dataY');
    var dataHeight = document.getElementById('dataHeight');
    var dataWidth = document.getElementById('dataWidth');
    var dataRotate = document.getElementById('dataRotate');
    var dataScaleX = document.getElementById('dataScaleX');
    var dataScaleY = document.getElementById('dataScaleY');
    var options = {
        autoCropArea: 1.0,
        logoType: '1',
        logoBottom: '0',
        textWhite: '1',
        textSource: 'Foto: THW',
//        aspectRatio: 1 / 1,
        aspectRatio: NaN,
//        aspectRatio: parseFloat($('input[name=aspectRatio]:checked').val(), 10) ?? NaN,
        viewMode: 1,
        preview: '.img-preview',
        ready: function (e) {
            console.log(e.type);

            initCiElements(e.detail);
        },
        cropstart: function (e) {
            console.log(e.type, e.detail.action);
        },
        cropmove: function (e) {
            console.log(e.type, e.detail.action);

            initCiElements(e.detail);
        },
        cropend: function (e) {
            console.log(e.type, e.detail.action);

            initCiElements(e.detail);
        },
        crop: function (e) {
            var data = e.detail;

            console.log(e.type);
            dataX.value = Math.round(data.x);
            dataY.value = Math.round(data.y);
            dataHeight.value = Math.round(data.height);
            dataWidth.value = Math.round(data.width);
            dataRotate.value = typeof data.rotate !== 'undefined' ? data.rotate : '';
            dataScaleX.value = typeof data.scaleX !== 'undefined' ? data.scaleX : '';
            dataScaleY.value = typeof data.scaleY !== 'undefined' ? data.scaleY : '';

            initCiElements(e.detail);
        },
        zoom: function (e) {
            console.log(e.type, e.detail.ratio);
        }
    };
    var cropper = new Cropper(image, options);
    var originalImageURL = image.src;
    var uploadedImageType = 'image/jpeg';
    var uploadedImageName = 'cropped.jpg';
    var uploadedImageURL;

    // Tooltip
    $('[data-toggle="tooltip"]').tooltip();

    // Buttons
    if (!document.createElement('canvas').getContext) {
        $('button[data-method="getCroppedCanvas"]').prop('disabled', true);
    }

    if (typeof document.createElement('cropper').style.transition === 'undefined') {
        $('button[data-method="rotate"]').prop('disabled', true);
        $('button[data-method="scale"]').prop('disabled', true);
    }

    // Download
    if (typeof download.download === 'undefined') {
        download.className += ' disabled';
        download.title = 'Your browser does not support download';
    }

    // Options
    var docs_toggles_onchange = function (event) {
        var e = event || window.event;
        var target = e.target || e.srcElement;
        var cropBoxData;
        var canvasData;
        var isCheckbox;
        var isRadio;
        var isText;

        if (!cropper) {
            return;
        }

        if (target.tagName.toLowerCase() === 'label') {
            target = target.querySelector('input');
        }

        isCheckbox = target.type === 'checkbox';
        isRadio = target.type === 'radio';
        isText = target.type === 'text';

        if (isCheckbox || isRadio || isText) {
            if (isCheckbox) {
                options[target.name] = target.checked;
                cropBoxData = cropper.getCropBoxData();
                canvasData = cropper.getCanvasData();

                options.ready = function () {
                    console.log('ready');
                    cropper.setCropBoxData(cropBoxData).setCanvasData(canvasData);
                };
            } else {
                options[target.name] = target.value;
                options.ready = function () {
                    console.log('ready');
                };
            }

            var afterUpdate = function () {
                cropper.destroy();
                cropper = new Cropper(image, options);
            };

            if (target.name === 'textWhite' || target.name === 'logoType' || target.name === 'logoBottom' || target.name === 'textSource') {
                afterUpdate = function () {
                    initCiElements({
                        'x': dataX.value,
                        'y': dataY.value,
                        'height': dataHeight.value,
                        'width': dataWidth.value
                    });
                };
            } else if (target.name === 'aspectRatio') {
//                afterUpdate = function () {
//                    cropper.reset();
//                    cropper.crop();
//                };
                $('[name=aspectRatio]:not(#' + target.id + ')').parent().removeClass('active');
            }
            afterUpdate();

        }
    };
    actions.querySelector('.docs-toggles-0').onchange = docs_toggles_onchange;
    actions.querySelector('.docs-toggles-1').onchange = docs_toggles_onchange;
    actions.querySelector('#textSource').onkeyup = docs_toggles_onchange;

    // Methods

    var docs_buttons_onclick = function (event) {
        var e = event || window.event;
        var target = e.target || e.srcElement;
        var cropped;
        var result;
        var input;
        var data;

        if (!cropper) {
            return;
        }

        while (target !== this) {
            if (target.getAttribute('data-method')) {
                break;
            }

            target = target.parentNode;
        }

        if (target === this || target.disabled || target.className.indexOf('disabled') > -1) {
            return;
        }

        data = {
            method: target.getAttribute('data-method'),
            target: target.getAttribute('data-target'),
            option: target.getAttribute('data-option') || undefined,
            secondOption: target.getAttribute('data-second-option') || undefined
        };

        cropped = cropper.cropped;

        if (data.method) {
            if (typeof data.target !== 'undefined') {
                input = document.querySelector(data.target);

                if (!target.hasAttribute('data-option') && data.target && input) {
                    try {
                        data.option = JSON.parse(input.value);
                    } catch (e) {
                        console.log(e.message);
                    }
                }
            }

            switch (data.method) {
                case 'rotate':
                    if (cropped && options.viewMode > 0) {
                        cropper.clear();
                    }

                    break;

                case 'getCroppedCanvas':
                    try {
                        data.option = JSON.parse(data.option);
                    } catch (e) {
                        console.log(e.message);
                    }

                    if (uploadedImageType === 'image/jpeg') {
                        if (!data.option) {
                            data.option = {};
                        }

                        data.option.fillColor = '#fff';
                    }

                    break;
            }

            result = cropper[data.method](data.option, data.secondOption);

            switch (data.method) {
                case 'rotate':
                    if (cropped && options.viewMode > 0) {
                        cropper.crop();
                    }

                    break;

                case 'scaleX':
                case 'scaleY':
                    target.setAttribute('data-option', -data.option);
                    break;

                case 'getCroppedCanvas':
                    if (result) {
                        // Bootstrap's Modal
                        $('#getCroppedCanvasModal').modal().find('.modal-body').html(result);

                        if (!download.disabled) {
                            download.disabled = true;
                            download.download = uploadedImageName + '.thw_ci.jpg';
//                            download.href = result.toDataURL(uploadedImageType);
                            setTimeout(function() {
                                download.disabled = false;
                                var resultTmp = $('#getCroppedCanvasModal').modal().find('.modal-body  > canvas').get(0);
                                download.href = resultTmp.toDataURL(uploadedImageType);
                            }, 250);
                        }
                    }

                    break;

                case 'destroy':
                    cropper = null;

                    if (uploadedImageURL) {
                        URL.revokeObjectURL(uploadedImageURL);
                        uploadedImageURL = '';
                        image.src = originalImageURL;
                    }

                    break;
            }

            if (typeof result === 'object' && result !== cropper && input) {
                try {
                    result.options = options;
                    input.value = JSON.stringify(result, null, "\t");
                } catch (e) {
                    console.log(e.message);
                }
            }
        }
    };
    
    actions0.querySelector('.docs-buttons-0').onclick = docs_buttons_onclick;
    actions.querySelector('.docs-buttons-1').onclick = docs_buttons_onclick;


    document.body.onkeydown = function (event) {
        var e = event || window.event;

        if (e.target !== this || !cropper || this.scrollTop > 300) {
            return;
        }

        switch (e.keyCode) {
            case 37:
                e.preventDefault();
                cropper.move(-1, 0);
                break;

            case 38:
                e.preventDefault();
                cropper.move(0, -1);
                break;

            case 39:
                e.preventDefault();
                cropper.move(1, 0);
                break;

            case 40:
                e.preventDefault();
                cropper.move(0, 1);
                break;
        }
    };

    // Import image
    var inputImage = document.getElementById('inputImage');

    if (URL) {
        inputImage.onchange = function () {
            var files = this.files;
            var file;

            if (files && files.length) {
                file = files[0];

                if (/^image\/\w+/.test(file.type)) {
                    uploadedImageType = file.type;
                    uploadedImageName = file.name;

                    if (uploadedImageURL) {
                        URL.revokeObjectURL(uploadedImageURL);
                    }

                    image.src = uploadedImageURL = URL.createObjectURL(file);

                    if (cropper) {
                        cropper.destroy();
                    }

                    cropper = new Cropper(image, options);
                    inputImage.value = null;
                } else {
                    window.alert('Please choose an image file.');
                }
            }
        };
    } else {
        inputImage.disabled = true;
        inputImage.parentNode.className += ' disabled';
    }

    function initCiElements(data) {
        if (data === undefined || data === null || data.width === undefined || data.height === undefined) {
            return;
        }
        var data_width = Math.round(data.width);
        var data_height = Math.round(data.height);

        $('.img-preview.preview-full').removeClass('logo_size_1_2 logo_size_1_3 logo_size_1_4');

        var data_ratio = data_width / data_height;
        var textSize = 0;
        var textPadding = 0;
        var logoSizePerc = 1 / 3;
        switch (true) {
            case data_ratio > 1.1:
                $('.img-preview.preview-full').addClass('logo_size_1_4');
                logoSizePerc = 1 / 4;
                break;
            case data_ratio < 0.9:
                $('.img-preview.preview-full').addClass('logo_size_1_2');
                logoSizePerc = 1 / 2;
                break;
            default:
                $('.img-preview.preview-full').addClass('logo_size_1_3');
                logoSizePerc = 1 / 3;
                break;
        }

        textSize = logoSizePerc / 100 * 3.8665;
        textPadding = logoSizePerc / 100 * 7.733;
        
        $('.img-preview.preview-full').removeClass('logo_type_0 logo_type_1 logo_type_2 logo_type_3').addClass('logo_type_' + options.logoType);

        if (options.logoBottom === '1') {
            if ($('.img-preview.preview-full.logo_bottom').length === 0) {
                $('.img-preview.preview-full').addClass('logo_bottom');
            }
        } else {
            $('.img-preview.preview-full').removeClass('logo_bottom');
        }

        if (options.textWhite === '1') {
            if ($('.img-preview.preview-full.text_white').length === 0) {
                $('.img-preview.preview-full').addClass('text_white');
            }
        } else {
            $('.img-preview.preview-full').removeClass('text_white');
        }

        // logo_type
        // logo_bottom

        // refetch the setted "img-preview preview-full" width and height
        // create new container ontop
        // $('.logo-thw')
        if ($('.logo_right').length === 0) {
            $('.img-preview.preview-full').append('<div class="logo_right"></div>');
        }
        if ($('.text_hint_left').length === 0) {
            $('.img-preview.preview-full').append('<div class="text_hint_left"><span>empty</span></div>');
        }
        if ($('.text_hint_left span').text() != options.textSource) {
            $('.text_hint_left span').text(options.textSource);
        }
        $('.logo_right').css({
            'width': $('.img-preview.preview-full').css('width'),
            'height': $('.img-preview.preview-full').css('height')
        });
        $('.text_hint_left').css({
            'width': $('.img-preview.preview-full').css('width'),
            'height': $('.img-preview.preview-full').css('height')
        });

        var blockWidth = parseInt($('.img-preview.preview-full').css('width'));
//        console.log([textPadding * blockWidth, textSize * blockWidth]);

        $('.text_hint_left span').css({
            'padding': (blockWidth * textPadding) + 'px',
            'font-size': (blockWidth * textSize * 1.35) + 'px',
            'line-height': (blockWidth * textSize * 1.35) + 'px',
            'bottom': '-' + ((blockWidth * textPadding * 2) + (blockWidth * textSize * 1.35)) + 'px'
        });

    }
};
